<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class AuditLog extends Model
{
    protected $table = 'audit_logs';
    protected $primaryKey = 'Log_id';
    public $timestamps = false; // No automatic timestamps, as per schema

    protected $fillable = [
        'User_id',
        'Action',
        'Details',
        'Created_at',
    ];

    protected $casts = [
        'Created_at' => 'datetime',
    ];

    public function user()
    {
        return $this->belongsTo(User::class, 'User_id', 'User_id');
    }
}
